<?php defined('SYSPATH') or die('No direct script access.');

class Task_Indexer_Client extends Minion_Task {

	/**
	 * Worker create Sphinx index for table "Clients"
	 *
	 * @param array $params
	 * @throws Kohana_Exception
	 */
    protected function _execute(array $params){
        $sphinxql = new SphinxQL();
        $fields = ['id', 'cid0', 'cid1', 'ip', 'prefix'];
        $config_name = Kohana::$config->load('init.insert.clients.name');

        $clients = DB::select('id', 'cid0', 'cid1', 'ip', 'prefix')
            ->from('clients')
            ->where('id', '>', Helper::getCounter('clients'))
	        ->order_by('id')
            ->limit(10000)
            ->execute()
            ->as_array();

	    if(!empty($clients)){
	        foreach($clients as $value){
	            $index = $sphinxql->new_query()
	                ->add_index($config_name)
	                ->where('id', $value['id'], '=')
	                ->execute();
	            if($index['total_info']['total_found'] == 0){
	                DB::insert($config_name, $fields)
	                    ->values($value)
	                    ->execute(Helper::getCurrentSphinx());
	            }
	        }

	        /* Update counter */
            $value = end($clients);
	        Helper::updCounter($value['id'], 'clients');
        }
    }
}
